﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace snakePart1
{
    /// <summary>
    /// Logique d'interaction pour MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            int rowRec = Grid.GetRow(snake);
            int colRec = Grid.GetColumn(snake);
            switch (e.Key.ToString())
            {
                case "Up":
                    top.Background = Brushes.Red;
                    if (rowRec > 0)
                    {
                        rowRec = rowRec - 1;
                        Grid.SetRow(snake, rowRec);//déplace le rectangle sur ces nouvelles coordonnées
                    }
                    break;

                case "Down":
                    down.Background = Brushes.Red;
                    if (rowRec < 15)
                    {
                        rowRec = rowRec + 1;
                        Grid.SetRow(snake, rowRec);
                    }
                    break;

                case "Right":
                    // Check if collided
                    right.Background = Brushes.Red;
                    if (colRec < 9)
                    {
                        colRec = colRec + 1;
                        Grid.SetColumn(snake, colRec);
                    }
                    break;
                case "Left":
                    left.Background = Brushes.Red;
                    // Check if collided
                    if (colRec > 0)
                    {
                        colRec = colRec - 1;
                        Grid.SetColumn(snake, colRec);
                    }
                    break;
            }

            Actual_Coord();
        }

        public void Actual_Coord()
        {
            coordX.Text = Grid.GetRow(snake).ToString();
            coordY.Text = Grid.GetColumn(snake).ToString();
        }

        private void Window_KeyUp(object sender, KeyEventArgs e)
        {
            switch (e.Key.ToString())
            {
                case "Up":
                    top.Background = Brushes.Gray;
                    break;
                case "Down":
                    down.Background = Brushes.Gray;
                    break;

                case "Right":
                    right.Background = Brushes.Gray;
                    break;
                case "Left":
                    left.Background = Brushes.Gray;
                    break;

            }
        }
    }
}
