﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace snakePart2
{
    /// <summary>
    /// Logique d'interaction pour MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        int _direction = 0; //variable qui permettra de savoir la derniere direction choisi par l'utilisateur
        Rectangle nourriture = new Rectangle();//rectangle correspondant à la nourriture, qui sera inséré dans la grille dynamiquement
        Random random = new Random(); //Nous permettra de placer la nourriture aléatoirement sur la grille


        public MainWindow()
        {
            InitializeComponent();
            DispatcherTimer timer = new DispatcherTimer();
            timer.Interval = TimeSpan.FromMilliseconds(150); //each 150 MilliSeconds the timer_Tick function will be executed
            timer.Tick += timer_Tick;
            timer.Start();
        }

        //Cette fonction déplacera le snake en fonction de la direction choisie
        void timer_Tick(object sender, EventArgs e)
        {
            //on récupère les coordonnées du snake sur la grille
            int rowRec = Grid.GetRow(snake);
            int colRec = Grid.GetColumn(snake);

            //on choisit des coordonnées aléatoire pour la nourriture
            int xFood = random.Next(0, snakeGrid.RowDefinitions.Count);
            int yFood = random.Next(0, snakeGrid.ColumnDefinitions.Count);

            //Si aucune nourriture n'est présente alors on l'ajoute 
            if (!snakeGrid.Children.Contains(nourriture) && _direction != 0)
            {
                //Le rectangle nourriture aura les meme dimensions que le snake
                nourriture.Width = snake.Width;
                nourriture.Height = snake.Height;
                //Couleur verte pour la nourriture
                nourriture.Fill = Brushes.Green;
                //On l'ajoute à la grille
                snakeGrid.Children.Add(nourriture);
                Grid.SetColumn(nourriture, yFood);
                Grid.SetRow(nourriture, xFood);
            }

            //en fonction de la direction, on déplace le snake
            switch (_direction)
            {

                case 1://up
                    if (rowRec > 0)
                    {
                        rowRec = rowRec - 1;
                        Grid.SetRow(snake, rowRec);//déplace le rectangle sur ces nouvelles coordonnées
                        Actual_Coord();
                    }
                    else
                    {
                        GameOver();
                    }
                    break;
                case 2://left
                    if (colRec > 0)
                    {
                        colRec = colRec - 1;
                        Grid.SetColumn(snake, colRec);
                        Actual_Coord();
                    }
                    else
                    {
                        GameOver();
                    }
                    break;
                case 3: //right
                    if (colRec < 9)
                    {
                        colRec = colRec + 1;
                        Grid.SetColumn(snake, colRec);
                        Actual_Coord();
                    }
                    else
                    {
                        GameOver();
                    }
                    break;
                case 4: //down
                    if (rowRec < 15)
                    {
                        rowRec = rowRec + 1;
                        Grid.SetRow(snake, rowRec);
                        Actual_Coord();
                    }
                    else
                    {
                        GameOver();
                    }
                    break;
            }


            if (Grid.GetRow(snake) == Grid.GetRow(nourriture) && Grid.GetColumn(snake) == Grid.GetColumn(nourriture))
            {
                snakeGrid.Children.Remove(nourriture);
            }

        }

        //Fonction activée quand le snake touche le bord de la grille
        //Affiche un message de défaite
        //replace le snake pour recommencer une partie
        public void GameOver()
        {
            MessageBox.Show("PERDU");
            snakeGrid.Children.Remove(nourriture);
            Grid.SetColumn(snake, 2);
            Grid.SetRow(snake, 2);
            _direction = 0;
            Actual_Coord();
        }

        //Fonction Actualisant les textBlock affichant les coordonnées du snake
        public void Actual_Coord()
        {
            coordX.Text = Grid.GetRow(snake).ToString();
            coordY.Text = Grid.GetColumn(snake).ToString();
        }


        //Event KeyDown, actualise la direction choisie par l'utilisateur
        //Change également la couleur des boutons representant les fleches du clavier
        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.Key.ToString())
            {
                case "Up":
                    _direction = 1;
                    top.Background = Brushes.Red;
                    break;

                case "Down":
                    _direction = 4;
                    down.Background = Brushes.Red;
                    break;

                case "Right":
                    _direction = 3;
                    right.Background = Brushes.Red;
                    break;
                case "Left":
                    _direction = 2;
                    left.Background = Brushes.Red;
                    break;

            }
        }


        //Event KeyUp, redonne leur couleur orginale aux boutons
        private void Window_KeyUp(object sender, KeyEventArgs e)
        {
            switch (e.Key.ToString())
            {
                case "Up":
                    top.Background = Brushes.Gray;
                    break;
                case "Down":
                    down.Background = Brushes.Gray;
                    break;

                case "Right":
                    right.Background = Brushes.Gray;
                    break;
                case "Left":
                    left.Background = Brushes.Gray;
                    break;
            }
        }

    }
}
