﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using Pendu;

namespace Pendu
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    ///


    public partial class MainWindow : Window
    {
        To_guess to_guess;

        public MainWindow()
        {
            InitializeComponent();

          
            to_guess = new To_guess();
            word_to_guess_label.Content =  to_guess.Initialize_word_to_guess_label();
            counter.Content = (10 - to_guess.Counter).ToString();



        }


        public string change_Advance_Word(string new_changes)
        {
            /*
             * Change the advance word (progression or the hidden word)
             */
            string new_advance = "";
            for(int i = 0; i < to_guess.Word_length; i++)
            {
                if(to_guess.Word_Advance[i] != '-')
                {
                    new_advance += to_guess.Word_Advance[i];

                }
                else if(new_changes[i] != '-')
                {
                    new_advance += new_changes[i];
                }
                else
                {
                    new_advance += '-';
                }
            }
            return new_advance;
        }


        public List<int> All_Indexes_Of()
        {
            /*
             * Returns all of the indexes of a char in a string
             */


            List<int> result = new List<int>();
            if (to_guess.Word.Contains(to_guess.Letter_proposed))
            {
                for (int i = 0; i < to_guess.Word_length; i++)
                {
                    if (to_guess.Word[i] == to_guess.Letter_proposed)
                    {
                        result.Add(i);
                    }
                }
            }
            return result;
        }

        public bool Propose_Letter()
        {

            /*
             * Propose a letter and shows it if it is in the word to guess.
             */
            bool result = false;
           


            if (propose_letter_textbox.Text.Length > 0)
            {
                
                to_guess.Letter_proposed = propose_letter_textbox.Text[0];

                

                List<int> all_indexes = All_Indexes_Of();

                if (all_indexes.Count > 0)
                {
                    result = true;
                    string new_str = "";
                    for (int i = 0; i < to_guess.Word_length; i++)
                    {
                        if (all_indexes.Contains(i))
                        {
                            new_str += to_guess.Word[i];
                        }
                        else
                        {
                            new_str += '-';
                        }
                    }
                    
                    to_guess.Word_Advance = change_Advance_Word(new_str);
                    word_to_guess_label.Content = to_guess.Word_Advance;

                }
                else
                {
                    to_guess.Counter += 1;
                }

                if (!already_tried_letters.Content.ToString().Contains(to_guess.Letter_proposed))
                {
                    already_tried_letters.Content += to_guess.Letter_proposed.ToString();
                }
                counter.Content = (10  - to_guess.Counter).ToString();


                propose_letter_textbox.Text = "";

            }


            Check_Victory_Defeat();
            return result;

        }

        public void Check_Victory_Defeat()
        {
            /*
             * Checks if the user has won / lost.
             */
            if (!to_guess.Word_Advance.Contains('-'))
            {
                MessageBox.Show("Vous avez gagné !");
            }
            else
            {
                if (to_guess.Counter > 10)
                {
                    MessageBox.Show("Vous avez perdu !");
                }
            }
        }

        private void Button_Try_Click(object sender, RoutedEventArgs e)
        {
            /*
             * Event that happens when the user proposes a letter
             */

            bool letter_is_in = Propose_Letter();
            if(letter_is_in)
            {
                propose_letter_textbox.Background = Brushes.Green;

            }
            else
            {
                propose_letter_textbox.Background = Brushes.Red;
            }
        }

  

        
    }


}
